using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class BCCCR_BCR_ALLDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public BCCCR_BCR_ALLDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public BCCCR_BCR_ALL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            BCCCR_BCR_ALL objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_BCCCR_BCR_ALL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<BCCCR_BCR_ALL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<BCCCR_BCR_ALL> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_BCCCR_BCR_ALL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, BCCCR_BCR_ALL objSave)
        {
            Int32? objReturn = objSave.ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_BCCCR_BCR_ALL_save(CURRENT_USER, 
                        CURRENT_REGISTRY_ID,
                        objSave.Age,
                        objSave.BIRADScore,
                        objSave.City,
                        char.Parse(objSave.CombatFlag),
                        objSave.DateNextMammogramDue,
                        objSave.DateOfBirth,
                        objSave.DateOFMostRecentMammogram,
                        objSave.DateOfMostRecentMammogramExclusionHealthFactor,
                        objSave.DateOfMostRecentMammogramResult,
                        objSave.DateOfMostRecentMammogramScreenFreq,
                        objSave.DateOfMostRecentNexusClinicEncounter,
                        objSave.DateOfMostRecentNexusClinicFormerEncounter,
                        objSave.DateOfMostRecentPrimaryCareEncounter,
                        objSave.DateOfMostRecentWomensHealthEncounter,
                        objSave.DateOfMostRRecentNexusClinicPriorEncounter,
                        objSave.DateOfNextAppointment,
                        objSave.DateProcessed,
                        char.Parse(objSave.Deceased),
                        objSave.Ethnicity,
                        char.Parse(objSave.Gender),
                        objSave.HadBilateralMastectomy,
                        objSave.HadHysterectomy,
                        objSave.HasATerminalHealthFactor,
                        objSave.HasMammogramExclusionHealthFactor,
                        objSave.HomeSta3N,
                        ref objReturn,
                        objSave.ISOEFOIF,
                        objSave.LocationNameOfNextAppointment,
                        objSave.MammogramComplianceText,
                        objSave.MammogramMostRecentScreenFreq,
                        objSave.MammogramMostrecentScreenFreqHF,
                        objSave.MammogramScreeningComplianceText,
                        objSave.MonthSID,
                        objSave.MostRecentMammogramDiagnosticCode,
                        objSave.MostRecentMammogramProcedure,
                        objSave.MostRecentMammogramSource,
                        objSave.NumberOfCancerDiagnosis,
                        objSave.NumberOfNexusClinicEncounters,
                        objSave.NumberOfNexusClinicFormerEncounters,
                        objSave.NumberOfNexusClinicPriorEncounters,
                        objSave.NumberOfPrimaryCareEncounters,
                        objSave.NumberOfTerminalCADDiagnosis,
                        objSave.NumberOfWomensHealthEncounters,
                        objSave.PatientFirstName,
                        objSave.PatientICN,
                        objSave.PatientIEN,
                        objSave.PatientLastName,
                        objSave.PatientSID,
                        objSave.PatientSNUM,
                        objSave.PCMMStaffName,
                        objSave.PCMMStaffSID,
                        objSave.PCMMTeam,
                        objSave.PCMMTeamSID,
                        objSave.PhoneCellular,
                        objSave.PhoneResidence,
                        objSave.PhoneWork,
                        objSave.Race,
                        objSave.Region,
                        objSave.Sta3n,
                        objSave.State,
                        objSave.StreetAddress1,
                        objSave.StreetAddress2,
                        objSave.StreetAddress3,
                        objSave.VAID,
                        char.Parse(objSave.VeteranFlag),
                        objSave.VISN,
                        objSave.WomensHealthVisitStatus, 
                        objSave.Zip);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_BCCCR_BCR_ALL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<BCCCR_BCR_ALL> GetItemsBySearch(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int16 STA3N, string PATIENT_SEARCH)
        {
            List<BCCCR_BCR_ALL> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_BCCCR_BCR_ALL_getitemsBySearch(CURRENT_USER, CURRENT_REGISTRY_ID, STA3N, PATIENT_SEARCH).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        #endregion
    }
}
